//
// paginateResults.java
//
import oracle.sql.*; 
import oracle.jdbc.*; 
import oracle.xml.sql.*; 
import oracle.xml.sql.query.*; 
import oracle.xml.sql.dataset.*; 
import oracle.xml.sql.docgen.*; 
import java.sql.*; 
import java.io.*; 

public class paginateResults 
{ 
  public static void main(String[] args) throws Exception 
  { 
    try
    {
      Connection conn  = getConnection("hr","hr");
// create a Statement object
      Statement stmt = 
        conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, 
                             ResultSet.CONCUR_READ_ONLY); 
// assign the sql query string
      String sCmd = "SELECT first_name, last_name FROM hr.employees"; 
// execute the sql query and assign results to rs
      ResultSet rs = stmt.executeQuery(sCmd); 
// create the query object
      OracleXMLQuery xmlQry = new OracleXMLQuery(conn, rs);
// configure the query object
      xmlQry.keepObjectOpen(true); 
      //xmlQry.setRowIdAttrName(""); 
      xmlQry.setRowsetTag("ROWSET"); 
      xmlQry.setRowTag("ROW"); 
      xmlQry.setMaxRows(20); 
      //rs.beforeFirst(); 
      String sXML = xmlQry.getXMLString(); 
      System.out.println(sXML); 
    }
    catch(SQLException e)
    {
      System.out.println(e.toString());
    }
  } // end main

// Get the connection given the user name and password
   private static Connection getConnection(String user, String passwd)
     throws SQLException
   {
      DriverManager.registerDriver(new oracle.jdbc.OracleDriver());
      Connection conn =
          DriverManager.getConnection("jdbc:oracle:oci:@",user,passwd);
      return conn;
   } // end getConnection
} // end paginateResults
